<?php
/**
 * D5 Readiness Translations for Divi Theme
 *
 * This file contains the translation strings for the Hero section
 * of the Divi theme. Each key-value pair consists of a string identifier
 * and its corresponding translated string.
 *
 * @package    Divi
 * @subpackage D5 Readiness / I18n
 * @since      ??
 */

// Translation strings for the Hero section.
return [
	'You’re Almost There!'                                     => esc_html__( 'You’re Almost There!', 'Divi' ),
	'Click Below To Migrate Your Site to Divi 50 Alpha'        => esc_html__( 'Click Below To Migrate Your Site to Divi 5.0 Alpha', 'Divi' ),
	'We are scanning your website'                             => esc_html__( 'We are scanning your website to assess its compatibility with Divi 5 Alpha. If your website is using modules that are not yet supported, we\'ll let you know which parts of your website will be affected so that you can decide whether or not to proceed with the migration. Unsupported modules will continue to function but won\'t benefit from Divi 5\'s performance improvements.', 'Divi' ),
	'$compatibleDescription'                                   => esc_html__( 'Congrulations! This site is 100% compatible with Divi 5 Alpha. You can safely migrate your site to Divi 5 Alpha to take advantage of the new builder and front end page speeds. Keep in mind that Divi 5 Alpha is a work in progress and is still missing features. You can always roll back to Divi 4, restoring your site to the current state and reverting any changes you made on Divi 5 Alpha.', 'Divi' ),
	'Subscribe to Stay Up to Date'                             => esc_html__( 'Subscribe to Stay Up to Date', 'Divi' ),
	'View Full Development Roadmap'                            => esc_html__( 'View Full Development Roadmap', 'Divi' ),
	'Learn More About Divi 5'                                      => esc_html__( 'Learn More About Divi 5', 'Divi' ),
	'All Widget Areas are Compatible %s'                       => esc_html__( 'All Widget Areas are Compatible with %s', 'Divi' ),
	'The sidebars and widget areas below contain %s'           => esc_html__( 'The sidebars and widget areas below contain modules that are not yet compatible with Divi 5. These modules will not be converted, and will continue to rely on the Divi 4 framework.', 'Divi' ),
	'Widgets are Incompatible %s'                              => esc_html__( 'Widgets are Incompatible with %s', 'Divi' ),
	'Plugins below contain %s'                                 => esc_html__( 'Plugins below use Divi hooks and may not yet be compatible with %s.', 'Divi' ),
	'All Plugins are Compatible %s'                            => esc_html__( 'All Plugins are Compatible with %s', 'Divi' ),
	'Plugins are Incompatible %s'                              => esc_html__( 'Plugins may be Incompatible with %s', 'Divi' ),
	'All Preset are Compatible %s'                             => esc_html__( 'All Presets are Compatible with %s', 'Divi' ),
	'In Progress'                                              => esc_html__( 'In Progress', 'Divi' ),
	'Coming Soon'                                              => esc_html__( 'Coming Soon', 'Divi' ),
	'Mmigrate This Site to %s'                                 => esc_html__( 'Migrate This Site to %s', 'Divi' ),
	'Uh Oh!'                                                   => esc_html__( 'Uh Oh!', 'Divi' ),
	'Your Site Is Using Features Not Fully Supported In %s'    => esc_html__( 'Your Site Is Using Modules Not Fully Supported By %s', 'Divi' ),
	'$notCompatibleDescription'                                => esc_html__( 'Your site uses modules that are not currently supported by %s. That\'s ok; you can still migrate. However, these modules won\'t be converted and will continue functioning using the Divi 4 framework. The parts of your website that use these modules will not benefit from Divi 5\'s performance improvements, and you may experience bugs while editing the modules in the builder. We are actively improving the backwards compatibility system. Since we are still in the alpha phase, third-party products from the Divi marketplace won\'t be ready for conversion yet.', 'Divi' ),
	'Re-Run Compatibility Check'                               => esc_html__( 'Re-Run Compatibility Check', 'Divi' ),
	'Download Compatibilty Report'                             => esc_html__( 'Download Compatibilty Report', 'Divi' ),
	'Roll Back to %s'                                          => esc_html__( 'Roll Back to %s', 'Divi' ),
	'Compatibility Check in Progress'                          => esc_html__( 'Compatibility Check in Progress...', 'Divi' ),
	'Hang Tight!'                                              => esc_html__( 'Hang Tight!', 'Divi' ),
	'Converting Your Site %s'                                  => esc_html__( 'We’re Migrating Your Site to the %s Framework!', 'Divi' ),
	'This may take several minutes'                            => esc_html__( 'This may take several minutes. Do not exit or refresh this page or your progress will be lost.', 'Divi' ),
	'Initializing Process'                                     => esc_html__( 'Initializing Process', 'Divi' ),
	'Migrating Your Pages'                                     => esc_html__( 'Migrating Your Pages', 'Divi' ),
	'Migrating Your Modules'                                   => esc_html__( 'Migrating Your Modules', 'Divi' ),
	'Migrating Your Templates'                                 => esc_html__( 'Migrating Your Templates', 'Divi' ),
	'Migrating Your Settings'                                  => esc_html__( 'Migrating Your Settings', 'Divi' ),
	'Finalizing Migration'                                     => esc_html__( 'Finalizing Migration', 'Divi' ),
	'Step %1$s: %2$s Compatibility Check'                      => esc_html__( 'Step %1$s: %2$s Compatibility Check', 'Divi' ),
	'Step %1$s: Migrate to %2$s'                               => esc_html__( 'Step %1$s: Migrate to %2$s', 'Divi' ),
	'$postutilizeNotCompatibleFeatures'                        => esc_html__( 'The %s below contain modules that are not yet compatible with Divi 5. These modules will not be converted, and will continue to rely on the Divi 4 framework.', 'Divi' ),
	'$postutilizesNotCompatibleFeatures'                       => esc_html__( 'The %s below contain modules that are not yet compatible with Divi 5. These modules will not be converted, and will continue to rely on the Divi 4 framework.', 'Divi' ),
	'$postisIncompatible'                                      => esc_html__( '%1$d %2$s is Incompatible with %3$s', 'Divi' ),
	'$postsareIncompatible'                                    => esc_html__( '%1$d %2$s are Incompatible with %3$s', 'Divi' ),
	'$allPostsCompatible'                                      => esc_html__( 'All %1$s are Compatible with %2$s', 'Divi' ),
	'%s Roadmap'                                               => esc_html__( '%s Roadmap', 'Divi' ),
	'%s Progress Updates'                                      => esc_html__( '%s Progress Updates', 'Divi' ),
	'Welcome to %s'                                            => esc_html__( 'Welcome to %s', 'Divi' ),
	'$upgradeCompleteDescription'                              => esc_html__( 'Congratulations! You migrated your website to the Divi 5 framework. You can return to this page anytime to run a new compatibility check to see if additional modules are ready for conversion or to convert any recently imported content. Throughout the beta process, new modules, such as Woo modules and modules from the Divi Marketplace, may be updated to support Divi 5. At this point, you can convert them using the migrator. Most third-party modules will not be ready for conversion at this early stage.', 'Divi' ),
	'The Divi 5 migration process failed'                      => esc_html__( 'The Divi 5 migration process failed. You can try rerunning the migrator; it will pick up where it left off. If the process continues to fail, please get in touch with our support team for assistance or roll back to Divi 4.', 'Divi' ),
	'We want to provide the community'                         => esc_html__( 'We want to provide the community with as much information as possible about the current state of Divi 5. We give monthly updates on our progress and cover various topics related to Divi 5.', 'Divi' ),
	'Uh Oh!'                                                   => esc_html__( 'Uh Oh!', 'Divi' ),
	'Something Went Wrong'                                     => esc_html__( 'Something Went Wrong While Migrating to Divi 5.0 Alpha', 'Divi' ),
	'Retry Divi'                                               => esc_html__( 'Retry Migration', 'Divi' ),
	'Subscribe to Stay Up to Date'                             => esc_html__( 'Subscribe to Stay Up to Date', 'Divi' ),
	'Progress Update'                                          => esc_html__( 'Progress Update: Front-End Speed Improvements (And Much More)', 'Divi' ),
	'March 28, 2024'                                           => esc_html__( 'March 28, 2024', 'Divi' ),
	'Re-Run Divi 5 Compatibility Check'                        => esc_html__( 'Re-Run Divi 5 Compatibility Check', 'Divi' ),
	'Migrating Your Pages'                                     => esc_html__( 'Migrating Your Pages', 'Divi' ),
	'Migrating Your Posts'                                     => esc_html__( 'Migrating Your Posts', 'Divi' ),
	'Migrating Your Modules'                                   => esc_html__( 'Migrating Your Modules', 'Divi' ),
	'Migrating Your Templates'                                 => esc_html__( 'Migrating Your Templates', 'Divi' ),
	'Migrating Your Settings'                                  => esc_html__( 'Migrating Your Settings', 'Divi' ),
	'Modules That Will be Converted (%s)'                      => esc_html__( 'Modules That Will be Converted (%s)', 'Divi' ),
	'Modules That Will Not Be Converted (%s)'                  => esc_html__( 'Modules That Will Not Be Converted (%s)', 'Divi' ),
	'%1$s Modules Ready to be Converted to %2$s'               => esc_html__( '%1$s Modules Ready to be Converted to %2$s', 'Divi' ),
	'The following items are used on your website'             => esc_html__( 'The following items are used on your website and are ready to be converted to the Divi 5 format.', 'Divi' ),
];
